import React, { ComponentType, FC } from 'react';
import { StatefulProvider } from './EditingContext';

export const withEditingProvider = <
  P extends {
    baseUrl?: string;
  }
>(
  WC: ComponentType<P>,
): FC<P & {
  /**
   * В случае, когда мы хотим инициализировать контекст самостоятельно
   * и перенести его на уровень выше, например, на всю страницу.
   *
   * ```tsx
   * <EditingProvider>
   *   <Tab>
   *     <EditableTable wrapSelfByContext={false} />
   *   </Tab>
   *   <Tab>
   *     <EditingModal />
   *   </Tab>
   * </EditingProvider>
   * ```
   */
  wrapSelfByContext?: boolean;
}> => (props) => {
  const { wrapSelfByContext = true, ...restProps } = props;

  if (wrapSelfByContext) {
    return (
      <StatefulProvider baseUrl={props.baseUrl}>
        <WC {...(restProps as P)} />
      </StatefulProvider>
    );
  }

  return <WC {...(restProps as P)} />;
};
