import React, { ComponentType, FC, useEffect, useState } from 'react';
import { get } from 'entry/api/common';
import { Table, TableProps } from '../../Table.types';
import { LoadProps, TableEndpointResponse } from './withLoad.types';

export const withLoad = (initialUrl: string = '') => (WC: ComponentType<TableProps>) => {
  const Load: FC<LoadProps & Omit<TableProps, 'tableData'>> = (props) => {
    const [table, setTable] = useState<Table>();
    const { url = initialUrl, ...restProps } = props;

    useEffect(() => {
      const promise = get<TableEndpointResponse>({
        url,
      }).then((response) => {
        if (response.data && response.data.table) {
          setTable(response.data.table);
        }
      });

      return () => {
        if (promise.isPending()) {
          promise.cancel();
        }
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);

    if (!table) {
      return null;
    }

    return <WC tableData={table} {...restProps} />;
  };

  return Load;
};
