import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { PaginationProps } from './Pagination.types';
import { PaginationItem } from './PaginationItem';
import { getPaginationSlice } from './utils/getPaginationSlice';
import css from './Pagination.module.css';

const nextIcon = () => (
  <span data-testid="paginationNextButton">
    <Icon className={css.Pagination__nextIcon} svg="arrowShort" svgSize="ms" />
  </span>
);

export const Pagination: FC<PaginationProps> = ({ pagination, paginationItemClick }) => {
  if (!pagination) {
    return null;
  }

  const paginationSlice = getPaginationSlice(pagination);
  const nextPage = pagination.pages[pagination.page];
  return (
    <div>
      {paginationSlice.map((page) => {
        return (
          <PaginationItem
            key={page.key || page.caption}
            paginationItemClick={paginationItemClick}
            page={page}
            activePage={pagination.page}
            disabled={!page.url}
          />
        );
      })}
      {nextPage && (
        <PaginationItem
          paginationItemClick={paginationItemClick}
          page={nextPage}
          Icon={nextIcon}
          activePage={pagination.page}
        />
      )}
    </div>
  );
};
