import React, { FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { PaginationItemProps } from './PaginationItem.types';

export const PaginationItem: FC<PaginationItemProps> = (props) => {
  const { page, activePage, paginationItemClick, disabled, text, Icon } = props;

  const isActive = Number(page.caption) === activePage;

  const handlePageClick = () => {
    if (!disabled) {
      paginationItemClick(page);
    }
  };

  return (
    <Button disabled={disabled} onClick={handlePageClick} view={isActive ? 'default' : 'clear'}>
      {Icon ? <Icon /> : text || page.caption}
    </Button>
  );
};
