import { Pagination as PaginationType, PaginationPage } from 'types/api/form/Form';

interface PaginationPageWithKey extends PaginationPage {
  key?: string;
}

const firstDotsItem = { caption: '...', url: '', key: 'firstDots' };
const lastDotsItem = { caption: '...', url: '', key: 'lastDots' };

export const getPaginationSlice = (pagination: PaginationType): PaginationPageWithKey[] => {
  const activePage = pagination.page;
  const collectionLength = pagination.pages.length;
  const count = 5;
  const firstCursor = activePage - count > 2 ? activePage - count : 1;
  const lastCursor = activePage + count;
  const needShowFirstDots = firstCursor > 1;
  const needShowLastDots = collectionLength - lastCursor > 1;
  let slice: PaginationPage[] = [pagination.pages[0]];
  if (needShowFirstDots) {
    slice.push(firstDotsItem);
  }
  slice = [...slice, ...pagination.pages.slice(firstCursor, lastCursor)];
  if (needShowLastDots) {
    slice[slice.length - 1] = lastDotsItem;
  }
  if (collectionLength - lastCursor > 0) {
    slice.push(pagination.pages[collectionLength - 1]);
  }
  return slice;
};
