import React, { ComponentType, FC } from 'react';
import css from './withPagination.module.css';
import { WithPaginationProps } from './withPagination.types';
import { Pagination } from './Pagination';

export const withPagination = <OwnProps extends object>(WC: ComponentType<OwnProps>) => {
  const ComponentWithPagination: FC<OwnProps & WithPaginationProps> = ({
    pagination,
    paginationItemClick,
    ...otherProps
  }) => {
    if (!pagination || pagination.pages.length < 2) {
      return <WC {...(otherProps as OwnProps)} />;
    }

    return (
      <div className={css.b}>
        <WC {...(otherProps as OwnProps)} />
        <Pagination pagination={pagination} paginationItemClick={paginationItemClick} />
      </div>
    );
  };

  return ComponentWithPagination;
};
