const liftTableWithFiltersRegex = new RegExp('/v0/blocks/lift.*/tableWithFilters', 'i');

const mapKeyToRegex = {
  liftTableWithFiltersRegex: liftTableWithFiltersRegex,
};

const mapRegexToNodeKey = {
  liftTableWithFiltersRegex: 'all-grids-in-lift',
};

export const getBunkerNodeKeys = (url?: string) => {
  if (!url) {
    return [];
  }

  const answer: Array<string> = [];

  Object.entries(mapKeyToRegex).forEach(([key, regex]) => {
    if (regex.test(url) && mapRegexToNodeKey[key]) {
      answer.push(`components/grid/${mapRegexToNodeKey[key]}`);
    }
  });

  const key = url
    .split('?')[0]
    ?.replace(/\//gi, '-')
    ?.toLowerCase();

  answer.push(`components/grid/${key}`);

  return answer;
};
