import { BunkerFieldSettings } from 'components/Table/Table.types';
import { ThemeTypes } from '../themes';
import { mapFieldsSettingsToDict } from './mapFieldsSettingsToDict';

interface getGridTemplateColumnsOptions {
  theme?: ThemeTypes;
  withSelect: boolean;
  fieldsSettings?: BunkerFieldSettings[];
}

export const getGridTemplateColumns = (columns, options: getGridTemplateColumnsOptions) => {
  const { withSelect, theme, fieldsSettings } = options;
  let result = '';
  if (withSelect) {
    result = theme === 'mg' ? 'auto' : '40px';
  }
  const fieldsSettingsAsMap = fieldsSettings ? mapFieldsSettingsToDict(fieldsSettings) : {};
  columns.forEach((col) => {
    const minColWidth = fieldsSettingsAsMap[col.id]?.minColumnWidth || '90px';
    const maxColWidth = fieldsSettingsAsMap[col.id]?.maxColumnWidth || '1fr';
    if (fieldsSettingsAsMap[col.id] || !col.columnWidth) {
      result += ` minmax(${minColWidth}, ${maxColWidth})`;
    } else {
      result += ` ${col.columnWidth}`;
    }
  });
  return result;
};
