import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { Bubble } from 'components/Bubble';
import { TagBubbleProps } from './TagBubble.types';

export const TagBubble: FC<TagBubbleProps> = ({ tag, ...restProps }) => {
  return (
    <Bubble {...restProps} title={tag.text} color={tag.color}>
      <Text typography="body-short-m">{tag.text}</Text>
    </Bubble>
  );
};
