import React, { useState } from 'react';
import { TagCollection } from './TagCollection';
import { BubbleLike } from './TagCollection.types';

export default {
  title: 'TagCollection',
  component: TagCollection,
  parameters: { actions: { argTypesRegex: '^on.*' } },
};

export const Default = (args) => {
  const [personal] = useState<BubbleLike[]>([
    {
      id: 1,
      text: 'Personal 1',
    },
    {
      id: 2,
      text: 'Personal 2',
    },
    {
      id: 3,
      text: 'Personal 3',
    },
  ]);
  const [common] = useState<BubbleLike[]>([
    {
      id: 4,
      text: 'Common 1',
    },
    {
      id: 5,
      text: 'Common 2',
    },
  ]);

  return (
    <div>
      <TagCollection {...args} personal={personal} common={common} />
    </div>
  );
};

Default.args = {
  isFocused: false,
};
