import { PropsWithChildren } from 'react';

export interface BubbleLike {
  id: number | string;
  text: string;
  color?: string;
}

export type TagCollectionProps<T extends BubbleLike = BubbleLike> = PropsWithChildren<{
  className?: string;
  common?: T[];
  personal?: T[];
  onChange?: (id: number | string) => void;
  creationText?: string;
  onCreate?: (text: string) => void;
  isFocused?: boolean;
}>;
