import React, { FC, ReactNode } from 'react';
import { TagBubble } from 'components/TagBubble';
import cx from 'classnames';
import { TagListProps } from './TagList.types';
import css from './TagList.module.css';

export const DEFAULT_PLACEHOLDER = '–';

export const TagList: FC<TagListProps> = ({ tags, className, placeholder, ...restProps }) => {
  const hasData = Boolean(Array.isArray(tags) && tags.length);

  if (!hasData && !placeholder) {
    return null;
  }

  let content: ReactNode = placeholder === true ? DEFAULT_PLACEHOLDER : placeholder;

  if (hasData) {
    content = tags!.map((tag) => <TagBubble key={tag.id} tag={tag} />);
  }

  return (
    <div className={cx(css.TagList, className)} {...restProps}>
      {content}
    </div>
  );
};
