import { HTMLAttributes, ReactNode } from 'react';
import { BubbleProps } from 'components/Bubble';

export interface TagListItem {
  id: string | number;
  text: BubbleProps['title'];
  color?: BubbleProps['color'];
}

export interface TagListProps<Tag = TagListItem>
  extends Omit<HTMLAttributes<HTMLDivElement>, 'placeholder'> {
  tags?: Tag[];
  /** true - use default */
  placeholder?: ReactNode;
}
