import React, { FC } from 'react';
import { Tag } from 'types';
import { TagList } from './TagList';
import { TagListProps } from './TagList.types';

export const TagListWithAdapter: FC<TagListProps<Tag>> = ({ tags, ...rest }) => {
  const formattedTags = (tags || []).map((tag) => ({ ...tag, text: tag.name }));

  return <TagList tags={formattedTags} {...rest} />;
};
