import React from 'react';
import { AttachmentListStatefulWithFileViewer } from 'components/AttachmentList';
import cx from 'classnames';
import { TemplatePreviewProps } from './TemplatePreview.types';
import css from './TemplatePreview.module.css';

export const TemplatePreview = ({
  title,
  body,
  files,
  className,
  ...other
}: TemplatePreviewProps) => {
  return (
    <div className={cx(className, css.TemplatePreview)} {...other}>
      {title && <div className={css.TemplatePreview__title}>{title}</div>}
      <div className={css.TemplatePreview__body} dangerouslySetInnerHTML={{ __html: body }} />
      {files && <AttachmentListStatefulWithFileViewer files={files} />}
    </div>
  );
};
