import React, { useContext } from 'react';
import css from './TemplateMenuItem.module.css';
import { templatesMenuServiceContext } from '../templatesMenuServiceContext';
import { TemplateMenuItemProps } from './TemplateMenuItem.types';

export const TemplateMenuItem = ({ children, template }: TemplateMenuItemProps) => {
  const templatesMenuService = useContext(templatesMenuServiceContext);

  return (
    <>
      <span
        className={css.TemplateMenuItem__overlay}
        onMouseEnter={() => {
          templatesMenuService.setTemplateForPreview(template);
        }}
      />
      {children}
    </>
  );
};
