import { makeAutoObservable, action } from 'mobx';
import { TemplateProvider, Template, TemplateItemAny } from 'types/TemplateProvider';
import { ITemplatesMenuService, TemplateType } from './TemplatesMenu.types';

export class TemplatesMenuService implements ITemplatesMenuService {
  filteredText: string = '';
  filteredType: string = '';
  template?: Template;
  types: TemplateType[] = [];
  templateProvider: TemplateProvider;

  constructor(templateProvider: TemplateProvider) {
    makeAutoObservable(this, {
      setFilterByText: action.bound,
      setFilterByType: action.bound,
      setTemplateForPreview: action.bound,
    });

    this.setTemplateProvider(templateProvider);
  }

  setFilterByText(text: string): void {
    this.filteredText = text;
  }

  setFilterByType(type: string): void {
    this.filteredType = type;
  }

  setTemplateForPreview(template: Template) {
    this.template = template;
  }

  setTemplateProvider(templateProvider: TemplateProvider): void {
    this.types = templateProvider
      .getTypes()
      .map((type) => ({ id: type.id, caption: type.caption }));
    this.filteredType = this.types[0]?.id;
    this.templateProvider = templateProvider;
  }

  getTemplateById(id: string): Template {
    return this.templateProvider.getTemplate(id);
  }

  get filteredTemplates(): TemplateItemAny[] {
    return this.templateProvider.getTemplateListByFilter({
      typeId: this.filteredType,
      text: this.filteredText,
    });
  }
}
