import React from 'react';
import { MailTemplateProvider, MailTemplateGroup } from 'services/MailTemplateProvider';
import { TemplatesMenu } from './TemplatesMenu';

const templateGroups: MailTemplateGroup[] = [
  {
    id: 'templates',
    caption: 'Шаблоны',
    items: [
      {
        bodyHtml: 'bodyHtml',
        bodyPlain: 'bodyPlain',
        id: 1,
        isDefault: false,
        type: 'type',
        typeName: 'typeName',
        name: 'long_name__long_name__long_name__long_name__long_name__',
      },
    ],
  },
  {
    id: 'signatures',
    caption: 'Подписи',
    items: [
      {
        bodyHtml: 'bodyHtml',
        bodyPlain: 'bodyPlain',
        id: 2,
        isDefault: false,
        type: 'type',
        typeName: 'typeName',
        name: 'name',
      },
    ],
  },
];

export default {
  title: 'TemplatesMenu',
  component: TemplatesMenu,
  args: {
    templateProvider: new MailTemplateProvider(templateGroups),
  },
  argTypes: {
    onTemplateClick: { action: 'templateClick' },
  },
};

export const Default = (args) => <TemplatesMenu {...args} />;
