import React from 'react';
import { observer } from 'mobx-react-lite';
import cx from 'classnames';
import { TemplatePreview } from 'components/TemplatePreview';
import css from './TemplatesMenu.module.css';
import { TemplatesMenuProps } from './TemplatesMenu.types';
import { TemplatesMenuSearch } from './TemplatesMenuSearch';
import { TemplatesMenuType } from './TemplatesMenuType';
import { TemplatesMenuFilteredList } from './TemplatesMenuFilteredList';
import { templatesMenuServiceContext } from './templatesMenuServiceContext';

export const TemplatesMenu = observer((props: TemplatesMenuProps) => {
  const { className, templatesMenuService, onTemplateClick } = props;

  const handleTemplateClick = (event) => {
    const { value } = event.target;

    const templateWithGroupId = templatesMenuService.getTemplateById(value);

    if (templateWithGroupId) {
      onTemplateClick(templateWithGroupId);
    }
  };

  return (
    <templatesMenuServiceContext.Provider value={templatesMenuService}>
      <div className={cx(className, css.TemplatesMenu)}>
        <div className={css.TemplatesMenu__list}>
          <TemplatesMenuType size="s" />
          <TemplatesMenuSearch size="s" placeholder="Поиск" hasClear />
          <TemplatesMenuFilteredList size="s" width="max" onChange={handleTemplateClick} />
        </div>
        {templatesMenuService.template && (
          <TemplatePreview
            title={templatesMenuService.template.name}
            body={templatesMenuService.template.bodyHtml}
            files={templatesMenuService.template.files}
          />
        )}
      </div>
    </templatesMenuServiceContext.Provider>
  );
});
