import { TemplateProvider, Template, TemplateItemAny } from 'types/TemplateProvider';

export interface TemplatesMenuProps {
  className?: string;
  templatesMenuService: ITemplatesMenuService;
  onTemplateClick(value: Template): void;
}

export interface TemplateType {
  id: string;
  caption: string;
}

export interface ITemplatesMenuService {
  setFilterByText(text: string): void;
  filteredText: string;

  setFilterByType(type: string): void;
  filteredType: string;
  types: TemplateType[];

  setTemplateProvider(templateProvider: TemplateProvider): void;
  templateProvider: TemplateProvider;

  setTemplateForPreview(template: Template): void;

  filteredTemplates: TemplateItemAny[];

  getTemplateById(id: string): Template;

  template?: Template;
}
