import React, { useContext } from 'react';
import { observer } from 'mobx-react-lite';
import Menu, { MenuWrapProps } from '@crm/components/dist/lego2/Menu';
import { templatesMenuServiceContext } from './templatesMenuServiceContext';
import { TemplateMenuItem } from './TemplateMenuItem';

export const TemplatesMenuFilteredList = observer(
  (props: Omit<MenuWrapProps, 'value' | 'items'>) => {
    const templatesMenuService = useContext(templatesMenuServiceContext);

    return (
      <Menu
        items={templatesMenuService.filteredTemplates.map((templateOrGroup) => {
          if ('items' in templateOrGroup) {
            return {
              title: templateOrGroup.caption,
              items: templateOrGroup.items.map((template) => ({
                value: template.id,
                content: (
                  <TemplateMenuItem template={template}>
                    {template.name || template.bodyPlain}
                  </TemplateMenuItem>
                ),
              })),
            };
          }
          return {
            value: templateOrGroup.id,
            content: (
              <TemplateMenuItem template={templateOrGroup}>
                {templateOrGroup.name || templateOrGroup.bodyPlain}
              </TemplateMenuItem>
            ),
          };
        })}
        {...props}
      />
    );
  },
);
