import React, { useContext } from 'react';
import { observer } from 'mobx-react-lite';
import Textinput, { TextinputProps } from '@crm/components/dist/lego2/Textinput';
import { templatesMenuServiceContext } from './templatesMenuServiceContext';

export const TemplatesMenuSearch = observer((props: Omit<TextinputProps, 'value' | 'onChange'>) => {
  const templatesMenuService = useContext(templatesMenuServiceContext);

  return (
    <Textinput
      onChange={templatesMenuService.setFilterByText}
      value={templatesMenuService.filteredText}
      {...props}
    />
  );
});
