import React, { useContext } from 'react';
import { observer } from 'mobx-react-lite';
import RadioButton, { RadioButtonProps } from '@crm/components/dist/lego2/RadioButton';
import { templatesMenuServiceContext } from './templatesMenuServiceContext';

export const TemplatesMenuType = observer(
  (props: Omit<RadioButtonProps, 'value' | 'onChange' | 'options'>) => {
    const templatesMenuService = useContext(templatesMenuServiceContext);

    return (
      <RadioButton
        onChange={templatesMenuService.setFilterByType}
        value={templatesMenuService.filteredType}
        options={templatesMenuService.types.map((type) => ({
          value: type.id,
          children: type.caption,
        }))}
        isEventValue={false}
        {...props}
      />
    );
  },
);
