import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { TextSelectionProps } from './TextSelection.types';
import css from './TextSelection.module.css';

export const TextSelection: FC<TextSelectionProps> = ({ value, range, className }) => {
  if (!range) {
    return (
      <Text overflow="ellipsis" typography="body-long-m" className={className}>
        <span title={value}>{value}</span>
      </Text>
    );
  }

  return (
    <Text overflow="ellipsis" typography="body-long-m" className={className}>
      <span title={value}>
        {value.substring(0, range[0])}
        <span className={css.Select__selection}>{value.substring(range[0], range[1])}</span>
        {value.substring(range[1])}
      </span>
    </Text>
  );
};
