export const getHoursAndMinutes = (time?: string) => {
  if (!time || time.indexOf(':') === -1) {
    return { hour: 0, minute: 0, second: 0 };
  }
  const [hours, minutes] = time.split(':');
  const hour = hours && Number(hours) <= 23 ? Number(hours) : 0;
  const minute = minutes && Number(minutes) <= 59 ? Number(minutes) : 0;
  return { hour, minute, second: 0 };
};

export const getTimesList = () => {
  const times: { content: string; value: string }[] = [];
  for (let i = 0; i <= 23; i++) {
    const hour1 = `${String(i).padStart(2, '0')}:00`;
    const hour2 = `${String(i).padStart(2, '0')}:30`;
    times.push({ value: hour1, content: hour1 });
    times.push({ value: hour2, content: hour2 });
  }
  return times;
};

export const formatTime = (date?: Date) => {
  if (date) {
    return (
      String(date.getHours()).padStart(2, '0') + ':' + String(date.getMinutes()).padStart(2, '0')
    );
  }
  return '';
};
