import React, { FC } from 'react';
import Modal from '@crm/components/dist/lego2/Modal';
import Button from '@crm/components/dist/lego2/Button';
import { placeholders } from 'modules/issues/components/Timeline/Call/CallInfo/FieldPlaceholder/FieldPlaceholder.constants';
import { Row } from './Row';
import { DetailsProps } from './Details.types';
import css from './Details.module.css';

export const Details: FC<DetailsProps> = (props) => {
  const { isVisible = false, call, onVisibleChange } = props;

  const handleClose = () => {
    onVisibleChange(false);
  };

  return (
    <Modal
      className={css.Details}
      visible={isVisible}
      theme="normal"
      onClose={handleClose}
      hasAnimation={false}
    >
      <span className={css.Details__title}>Детали звонка</span>

      <div className={css.Details__rows}>
        <Row
          className={css.Details__row}
          keyText="ФИО контакта"
          valueText={call.clientInfo?.name || call.kik?.name || placeholders.kikName}
        />
        <Row
          className={css.Details__row}
          keyText="Телефон"
          valueText={call.clientInfo?.phone || call.kik?.phoneE164 || placeholders.kikPhone}
        />
        <Row
          className={css.Details__row}
          keyText="Телефон Яндекса"
          valueText={call.operatorPhoneNumber}
        />
        <Row className={css.Details__row} keyText="Статус" valueText={call.callStatus.name} />
        {call.endReason && (
          <Row className={css.Details__row} keyText="Причина" valueText={call.endReason.name} />
        )}
        {call.duration && (
          <Row
            className={css.Details__row}
            keyText="Продолжительность звонка"
            valueText={call.duration.toString()}
          />
        )}
        <Row className={css.Details__row} keyText="Call ID" valueText={call.callId} />
      </div>

      <Button view="clear" className={css.Details__button} onClick={handleClose}>
        Закрыть
      </Button>
    </Modal>
  );
};
