import React, { FC } from 'react';
import cx from 'classnames';
import css from './Row.module.css';
import { RowProps } from './Row.types';

export const Row: FC<RowProps> = ({ keyText, valueText, className }) => {
  return (
    <div className={cx(css.Row, className)}>
      <div className={css.Row__key}>{keyText}</div>
      <div className={css.Row__value}>{valueText}</div>
    </div>
  );
};
