import React from 'react';
import { storiesOf } from '@storybook/react';
import { TestBed } from 'components/TestBed';
import { User } from 'types/entities/user';
import { Call } from 'types/entities/call';
import { TimelineCall } from './TimelineCall';

const audio = new Audio();

const TimelineCallStories = () => {
  return (
    <TestBed>
      <div style={{ background: '#eaeaea', padding: 100 }}>
        <TimelineCall
          audio={audio}
          call={{} as Call}
          date={new Date().toISOString()}
          author={{} as User}
        />
      </div>
    </TestBed>
  );
};

storiesOf('TimelineCall', module).add('TimelineCall', () => <TimelineCallStories />);
