import React, { FC, useRef, useState } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { AudioSource } from 'components/AudioSource';
import { TimelineItem2 } from 'components/TimelineItem2';
import { Popup } from 'components/design/ListItem/Popup';
import { Group } from 'components/design/ListItem/Group';
import { Direction } from '@crm/components/dist/lego2/withOldDirections';
import { audioRecordSrc } from 'utils/audioRecordSrc';
import { audioMetaSrc } from 'utils/audioMetaSrc';
import { TimelineItemTags } from 'modules/tags';
import { Details } from './Details';
import { TimelineCallProps } from './TimelineCall.types';
import css from './TimelineCall.module.css';

const directions: Direction[] = ['bottom-center'];
export const TimelineCall: FC<TimelineCallProps> = (props) => {
  const {
    date,
    upsaleFactors,
    dateUrl,
    highlight,
    author,
    call,
    audio,
    beforeContent,
    metaCacheClearKey,
    tags,
    activityId,
    showTags = false,
  } = props;
  const [areDetailsVisible, setDetailsVisible] = useState(false);
  const [isPopupVisible, setPopupVisible] = useState(false);

  const optionsActionRef = useRef<HTMLButtonElement>(null);

  const groupItems = [
    {
      value: 'showDetails',
      name: 'Показать детали звонка',
    },
  ];

  const sideActions = [
    {
      key: 'options',
      children: <Icon svg="moreVert" key="options" svgSize="l" />,
      onClick: () => {
        setPopupVisible(!isPopupVisible);
      },
      innerRef: optionsActionRef,
    },
    ...(props.sideActions || []),
  ];

  const handleOutsideClick = () => {
    setPopupVisible(false);
  };

  const handleGroupChange = (item: typeof groupItems[0]) => {
    if (item.value === 'showDetails') {
      setDetailsVisible(true);
    }

    setPopupVisible(false);
  };

  return (
    <TimelineItem2
      highlight={highlight}
      dateUrl={dateUrl}
      date={date}
      author={author}
      sideActions={sideActions}
      upsaleFactors={upsaleFactors}
    >
      {beforeContent}
      <AudioSource
        audio={audio}
        src={audioRecordSrc(call.id)}
        metaSrc={audioMetaSrc(call.id)}
        metaCacheClearKey={metaCacheClearKey}
      />
      {showTags && (
        <TimelineItemTags
          className={css.TimelineCall__tags}
          eType="Activity"
          name={`Activity${activityId}`}
          id={activityId}
          tags={tags}
          canEdit
        />
      )}
      <Popup
        className={css.TimelineCall__popup}
        mainOffset={20}
        directions={directions}
        anchor={optionsActionRef}
        visible={isPopupVisible}
        hasTail
        onOutsideClick={handleOutsideClick}
      >
        <Group isFocused={isPopupVisible} items={groupItems} onChange={handleGroupChange} />
      </Popup>
      <Details isVisible={areDetailsVisible} onVisibleChange={setDetailsVisible} call={call} />
    </TimelineItem2>
  );
};
