import React from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import cx from 'classnames';
import { UserLink } from 'components/UserLink';
import { InviteesProps } from './Invitees.types';
import css from './Invitees.module.css';

export const Invitees: React.FC<InviteesProps> = ({ invitees, className }) => {
  return (
    <div className={cx(css.Invitees, className)}>
      <Text color="secondary" className={css.Invitees_title}>
        Призваны:
      </Text>
      <div className={css.Invitees__usersContainer}>
        {invitees.map((user) => (
          <UserLink key={user.id} user={user} />
        ))}
      </div>
    </div>
  );
};
