import React from 'react';
import { TimelineItem2 } from 'components/TimelineItem2';
import { MessageWithWikiFormatterStateful } from 'components/MessageWithWikiFormatter';
import { TimelineCommentProps } from './TimelineComment.types';
import { Invitees } from './Invitees';
import css from './TimelineComment.module.css';

export const TimelineComment: React.FC<TimelineCommentProps> = (props) => {
  const {
    data,
    upsaleFactors,
    className,
    beforeContent,
    sideActions,
    mainActions,
    statusActions,
    highlight,
    linkToTimelineItem,
    alignment,
    backgroundColor = '#FFFFCC',
  } = props;
  const { author, dt, files, html, text, status, invitees } = data;

  return (
    <TimelineItem2
      className={className}
      author={author}
      date={new Date(dt).toISOString()}
      dateUrl={linkToTimelineItem}
      sideActions={sideActions}
      mainActions={mainActions}
      statusActions={statusActions}
      highlight={highlight}
      dateDisplayType={'block'}
      alignment={alignment}
      status={status}
      backgroundColor={backgroundColor}
      upsaleFactors={upsaleFactors}
    >
      {beforeContent}
      <MessageWithWikiFormatterStateful files={files} text={text} html={html} />
      {Boolean(invitees.length) && (
        <Invitees className={css.TimelineComment__invitees} invitees={invitees} />
      )}
    </TimelineItem2>
  );
};
