import React, { FC } from 'react';
import { FormattedDate } from 'react-intl';
import cx from 'classnames';
import Avatar from 'components/Avatar';
import Button from '@crm/components/dist/lego2/Button';
import Link from '@crm/components/dist/lego2/react-router/Link';
import StaffCard from 'components/StaffCard';
import Toolbar from 'components/Toolbar';
import { TimelineItemProps } from './TimelineItem.types';
import css from './TimelineItem.module.css';

export const TimelineItem: FC<TimelineItemProps> = (props) => {
  const {
    htmlId,
    className,
    children,
    date,
    dateUrl,
    author,
    actions,
    onClick,
    highlight,
    color,
    icon,
    side,
    afterAuthorName,
  } = props;

  const rootClassName = cx(className, css.TimelineItem, css[`TimelineItem_color_${color}`], {
    [css.TimelineItem_highlight]: highlight,
  });

  return (
    <div className={rootClassName} id={htmlId}>
      <div className={cx(css.TimelineItem__side)}>
        <span className={css.TimelineItem__icon}>{icon}</span>
        {side}
      </div>
      <div className={css.TimelineItem__header} onClick={onClick}>
        <div className={css.TimelineItem__authorAvatar}>
          <Avatar user={author} size="xs" theme="round" />
        </div>
        <StaffCard user={author} theme="yandex" className={css.TimelineItem__author} />
        {afterAuthorName}
        <div className={css.TimelineItem__headerSide}>
          {/* eslint-disable-next-line @typescript-eslint/no-explicit-any */}
          <Link to={dateUrl as any} className={css.TimelineItem__date} theme="ghost">
            <FormattedDate
              value={new Date(date)}
              year="numeric"
              month="numeric"
              day="numeric"
              hour="numeric"
              minute="numeric"
            />
          </Link>
        </div>
      </div>
      <div className={css.TimelineItem__preview}>{children}</div>
      {Array.isArray(actions) && Boolean(actions.length) && (
        <Toolbar className={css.TimelineItem__actions}>
          {actions.map((action) => (
            <Button size="xs" view="pseudo" {...action} key={action.key} />
          ))}
        </Toolbar>
      )}
    </div>
  );
};
