import { ButtonProps } from '@crm/components/dist/lego2/Button';
import { User } from 'types/entities/user';
import { ExternalPassportUser } from 'types/ExternalPassportUser';

export interface Action extends ButtonProps {
  key: number | string;
}

export type ColorType = 'grey' | 'orange' | 'red' | 'green' | 'blue';

export interface TimelineItemProps {
  className?: string;
  children: React.ReactNode;
  side?: React.ReactNode;
  afterAuthorName?: React.ReactNode;
  actions?: Action[];
  date: string;
  dateUrl?: string;
  author: User | ExternalPassportUser;
  onClick?: () => void;
  highlight?: boolean;
  color?: ColorType;
  icon?: React.ReactNode;
  htmlId?: string;
}
