import { IconExtendProps } from '@crm/components/dist/lego2/Icon';
import { TimelineItemStatus } from 'types/TimelineItemStatus';

export const statusIconProps: Record<
  TimelineItemStatus,
  Pick<IconExtendProps, 'svg' | 'svgSize'>
> = {
  [TimelineItemStatus.Sending]: {
    svg: 'recent',
    svgSize: 'ml',
  },
  [TimelineItemStatus.Sent]: {
    svg: 'chatCheck',
    svgSize: 'm',
  },
  [TimelineItemStatus.Delivered]: {
    svg: 'doubleChatCheck',
    svgSize: 'm',
  },
  [TimelineItemStatus.Failed]: {
    svg: 'error',
    svgSize: 'ms',
  },
};

export const TOOLTIP_OPENDELAY = 500;
