import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import css from './StatusIconAction.module.css';
import { StatusIconActionProps } from './StatusIconAction.types';

export const StatusIconAction: React.FC<StatusIconActionProps> = ({
  containerClassName,
  className,
  children,
  ...props
}) => {
  return (
    <div className={cx(css.StatusIconAction, containerClassName)}>
      <Button className={cx(css.StatusIconAction__button, className)} view="clear" {...props}>
        {children}
      </Button>
    </div>
  );
};
