import { Story } from '@storybook/react';
import React from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { User } from 'types/entities/user';
import { TimelineItemStatus } from 'types/TimelineItemStatus';
import { TimelineItemAlignment } from 'types/TimelineItemAlignment';
import { TestBed } from 'components/TestBed';
import { TimelineItem2 } from './TimelineItem2';
import { Action, TimelineItem2Props } from './TimelineItem2.types';

export default {
  title: 'TimelineItem2',
  component: TimelineItem2,
  parameters: {
    backgrounds: {
      default: 'Light grey',
      values: [
        {
          name: 'Light grey',
          value: '#eee',
        },
        {
          name: 'Dark grey',
          value: '#aaa',
        },
      ],
    },
  },
};

const sideActions: Action[] = [
  {
    key: 'options',
    children: <Icon svg="moreVert" key="options" svgSize="l" />,
  },
  {
    key: 'categorization',
    children: <Icon svg="categorization" key="categorization" svgSize="l" />,
  },
];

const mainActions: Action[] = [
  {
    key: 'options',
    children: 'Ответить',
  },
  {
    key: 'categorization',
    children: 'Удалить',
  },
];

const upsaleFactors = [
  {
    id: 1,
    name: 'ДО',
  },
  {
    id: 2,
    name: 'Ретаргетинг и аудитории',
  },
];

const Template: Story<TimelineItem2Props & { childText: string }> = (args) => (
  <TestBed>
    <TimelineItem2
      {...args}
      date={new Date().toISOString()}
      sideActions={sideActions}
      mainActions={mainActions}
      children={<> {args.children} </>}
    />

    <br />

    <TimelineItem2
      author={{} as User}
      date={new Date().toISOString()}
      children={<span> Test message about how I spend my summer. It was delightful time. </span>}
      sideActions={sideActions}
      mainActions={mainActions}
      highlight={false}
      dateDisplayType={'block'}
      alignment={TimelineItemAlignment.Right}
      status={TimelineItemStatus.Delivered}
      upsaleFactors={upsaleFactors}
    />
  </TestBed>
);

export const Default = Template.bind({});

Default.args = {
  highlight: false,
  dateDisplayType: 'block',
  alignment: TimelineItemAlignment.Left,
  children: 'Test message',
};
