import { ReactNode } from 'react';
import { ButtonProps } from '@crm/components/dist/lego2/Button';
import { TimelineItemStatus } from 'types/TimelineItemStatus';
import { TimelineItemAlignment } from 'types/TimelineItemAlignment';
import { UpsaleFactors } from 'types/entities/upsale';

import { AvatarUser } from '../Avatar/Avatar';

export interface Action extends ButtonProps {
  key?: number | string;
  render?: () => ReactNode;
}

export type StatusActions = {
  [Key in TimelineItemStatus]?: {
    tooltip?: string;
    actions?: Action[];
  };
};

export interface TimelineItem2Props {
  className?: string;
  children: React.ReactNode;
  mainActions?: Action[];
  sideActions?: Action[];
  statusActions?: StatusActions;
  date: string;
  dateUrl?: string;
  author: AvatarUser;
  onClick?: () => void;
  highlight?: boolean;
  dateDisplayType?: 'block' | 'overlay';
  alignment?: TimelineItemAlignment;
  status?: TimelineItemStatus;
  backgroundColor?: string;
  upsaleFactors?: UpsaleFactors;
  addonBeforeDate?: React.ReactNode;
}
