import React from 'react';
import { TimelineItem2 } from 'components/TimelineItem2';
import { Mail2Stateful } from 'components/Mail2';
import { Text } from '@crm/components/dist/lego2/Text';
import { MailType } from 'types/Mail';
import cx from 'classnames';
import { TimelineMailProps } from './TimelineMail.types';
import css from './TimelineMail.module.css';

export const TimelineMail: React.FC<TimelineMailProps> = (props) => {
  const {
    data,
    upsaleFactors,
    className,
    beforeContent,
    sideActions,
    mainActions,
    statusActions,
    highlight,
    linkToTimelineItem,
    alignment,
    backgroundColor,
  } = props;
  const { id, date, author, from, to, cc, bcc, subject, body, isHtml, files, status, type } = data;

  const isDraft = type === MailType.Draft;
  const addonBeforeDate = isDraft && <Text className={css.TimelineMail__draftTitle}>Черновик</Text>;

  return (
    <TimelineItem2
      className={cx(className, { [css.TimelineMail_draft]: isDraft })}
      author={author}
      date={new Date(date).toISOString()}
      dateUrl={linkToTimelineItem}
      sideActions={sideActions}
      mainActions={mainActions}
      statusActions={statusActions}
      highlight={highlight}
      dateDisplayType={'overlay'}
      alignment={alignment}
      status={status}
      backgroundColor={backgroundColor}
      upsaleFactors={upsaleFactors}
      addonBeforeDate={addonBeforeDate}
    >
      {beforeContent}
      <Mail2Stateful
        id={String(id)}
        from={from}
        to={to}
        cc={cc}
        bcc={bcc}
        subject={subject}
        body={body}
        isHtml={isHtml}
        files={files}
        contentClassName={css.TimelineMail__content}
      />
    </TimelineItem2>
  );
};
