import React, { FC } from 'react';
import { Meeting } from 'components/Meeting';
import { TimelineItem, Action } from 'components/TimelineItem';
import Access from 'utils/Access';
import { useDynamicallyModalForm } from 'components/DynamicallyModalForm';
import { TimelineMeetingProps } from './TimelineMeeting.types';

export const TimelineMeeting: FC<TimelineMeetingProps> = (props) => {
  const { meeting, editAccess, ...restProps } = props;
  const { dt, author, data } = meeting || {};
  const activityForm = useDynamicallyModalForm();

  const actions: Action[] = [];
  if (Access.isEdit(editAccess)) {
    actions.push({
      key: 'edit',
      children: 'Редактировать',
      onClick: () => {
        const row = data.data[0];
        if (row.url) {
          activityForm.setUrl(row.url).loadForm();
        }
      },
    });
  }

  return (
    <TimelineItem color="green" date={dt} author={author} actions={actions} {...restProps}>
      <Meeting data={data} />
    </TimelineItem>
  );
};
