import React from 'react';
import { TimelineItem2 } from 'components/TimelineItem2';
import { MessageStateful } from 'components/Message';
import { TimelineMessageProps } from './TimelineMessage.types';
import css from './TimelineMessage.module.css';

export const TimelineMessage: React.FC<TimelineMessageProps> = (props) => {
  const {
    data,
    upsaleFactors,
    className,
    beforeContent,
    sideActions,
    mainActions,
    statusActions,
    highlight,
    linkToTimelineItem,
    alignment,
    backgroundColor,
  } = props;

  const { author, text, createdOn, files, status } = data;

  return (
    <TimelineItem2
      className={className}
      author={author}
      date={new Date(createdOn).toISOString()}
      dateUrl={linkToTimelineItem}
      sideActions={sideActions}
      mainActions={mainActions}
      statusActions={statusActions}
      highlight={highlight}
      dateDisplayType={'block'}
      alignment={alignment}
      status={status}
      backgroundColor={backgroundColor}
      upsaleFactors={upsaleFactors}
    >
      {beforeContent}
      <MessageStateful className={css.TimelineMessage__message} text={text} files={files} />
    </TimelineItem2>
  );
};
