import { MS_IN_SECOND } from 'constants/time';
import React, { FC, useCallback, useMemo, useState } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { useInterval } from 'utils/hooks/useInterval';
import { getFormattedTimerValue, getMsPassed } from './Timer.utils';
import { TimerProps } from './Timer.config';

export const Timer: FC<TimerProps> = ({ isActive, startDate, endDate, timePassedMs = 0 }) => {
  const [ms, setMs] = useState(startDate ? getMsPassed(startDate, endDate) : timePassedMs);

  const updateMs = useCallback(() => {
    setMs((seconds) => seconds + MS_IN_SECOND);
  }, []);

  useInterval({ callback: updateMs, timeout: MS_IN_SECOND, isActive });

  const timerValue = useMemo(() => {
    if (isActive || !endDate || !startDate || !timePassedMs) {
      return ms;
    }

    return endDate && startDate ? getMsPassed(startDate, endDate) : timePassedMs;
  }, [endDate, isActive, ms, startDate, timePassedMs]);

  return (
    <Text typography="body-short-l" color={isActive ? 'primary' : 'secondary'} weight="medium">
      {getFormattedTimerValue(timerValue)}
    </Text>
  );
};
