export const getMsPassed = (startDate: string, endDate?: string) => {
  const msNow = endDate ? new Date(endDate).getTime() : Date.now();
  const msStart = new Date(startDate).getTime();

  return msNow - msStart;
};

export const getFormattedTimerValue = (value: number) => {
  const date = new Date(value);
  const hours = date.getUTCHours();
  const minutes = date.getUTCMinutes();
  const seconds = date.getUTCSeconds();

  const hoursPart = hours > 0 ? `${hours}`.padStart(2, '0') + ':' : '';
  const minutesPart = `${minutes}`.padStart(2, '0') + ':';
  const secondsPart = `${seconds}`.padStart(2, '0');

  return `${hoursPart}${minutesPart}${secondsPart}`;
};
