/*
eslint-disable
jsx-a11y/no-static-element-interactions,
jsx-a11y/click-events-have-key-events
*/

import * as React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from './Tip.scss';

interface Props {
  tip?: {
    body: string;
    backgroundColor: string;
  };
  className?: string;
}

interface State {
  show: boolean;
}

class Tip extends React.Component<Props, State> {
  public state = {
    show: true,
  };

  public componentDidUpdate(prevProps: Readonly<Props>): void {
    if (!this.state.show && prevProps.tip !== this.props.tip) {
      // eslint-disable-next-line react/no-did-update-set-state
      this.setState({ show: true });
    }
  }

  private handleToggle = (): void => {
    const { show } = this.state;

    this.setState({ show: !show });
  };

  public render(): React.ReactNode {
    const { tip, className } = this.props;
    const { show } = this.state;

    if (!tip) {
      return null;
    }

    if (show) {
      return (
        <div
          className={cx(className, css.b, css.b_open)}
          style={{ background: tip.backgroundColor }}
        >
          <Button
            className={css.b__collapse}
            view="clear"
            size="xs"
            title="Свернуть"
            onClick={this.handleToggle}
            icon={(iconCls) => <Icon className={iconCls} type="arrow" direction="top" />}
          />
          <div className={css.b__bodyWrap}>
            <div className={css.b__body} dangerouslySetInnerHTML={{ __html: tip.body }} />
          </div>
        </div>
      );
    }

    return (
      <div
        style={{ background: tip.backgroundColor }}
        className={cx(className, css.b, css.b_hide)}
        onClick={this.handleToggle}
      >
        Показать подсказку
      </div>
    );
  }
}

export default Tip;
