import React, { FC } from 'react';
import cx from 'classnames';
import { FullScreen } from 'components/FullScreen';
import { Overlay } from 'components/Overlay';
import { TipProps } from './Tip.types';
import css from './Tip.module.css';

export const Tip: FC<TipProps> = (props) => {
  const {
    children,
    renderContent,
    renderFullScreen,
    isExpanded,
    isFullScreen,
    onExpandChange,
    onFullScreenChange,
    className: outerClassName,
    ...divProps
  } = props;
  const className = cx(css.Tip, outerClassName);

  const enableFullScreen = () => {
    onFullScreenChange(true);
  };

  const disableFullScreen = () => {
    onFullScreenChange(false);
  };

  const toggleExpand = () => {
    onExpandChange(!isExpanded);
  };

  return (
    <div className={className} {...divProps}>
      {children(isExpanded, toggleExpand)}
      {isExpanded && renderContent(enableFullScreen)}
      {isFullScreen && (
        <FullScreen>
          <Overlay
            hasSpinner={false}
            display
            color="rgba(0, 0, 0, .4)"
            onClick={disableFullScreen}
          />
          <div className={css.Tip__fullScreenContent} role="dialog">
            {renderFullScreen(disableFullScreen)}
          </div>
        </FullScreen>
      )}
    </div>
  );
};
