import { HTMLAttributes } from 'react';

type EmptyCallback = () => void;

export interface StatefulProps {
  isExpanded: boolean;
  onExpandChange: (isExpanded: boolean) => void;
  isFullScreen: boolean;
  onFullScreenChange: (isFullScreen: boolean) => void;
}

export interface TipProps extends StatefulProps, HTMLAttributes<HTMLDivElement> {
  className?: string;
  children: (isExpanded: boolean, onToggle: EmptyCallback) => React.ReactNode;
  renderContent: (onFullScreen: EmptyCallback) => React.ReactNode;
  renderFullScreen: (onClose: EmptyCallback) => React.ReactNode;
}
