import React, { ComponentType, FC, useState } from 'react';
import { TipProps, StatefulProps } from '../Tip.types';

export const withSelfState = (
  Tip: ComponentType<TipProps>,
): FC<Omit<TipProps, keyof StatefulProps>> => (props) => {
  const [isExpanded, setExpanded] = useState(false);
  const [isFullScreen, setFullScreen] = useState(false);

  return (
    <Tip
      {...props}
      isExpanded={isExpanded}
      onExpandChange={setExpanded}
      isFullScreen={isFullScreen}
      onFullScreenChange={setFullScreen}
    />
  );
};
