import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './Toolbar.modules.scss';

/** @deprecated use src/components/Toolbar2 */
const Toolbar = (props) => {
  const { className, reverse, align, inline, justifyContent, ...passPropsThrough } = props;

  const resultClassName = cx(
    className,
    css.Toolbar,
    css[`Toolbar_align_${align}`],
    css[`Toolbar_justifyContent_${justifyContent}`],
    {
      [css.Toolbar_inline]: inline,
      [css.Toolbar_reverse]: reverse,
      [css[`Toolbar_reverse_${justifyContent}`]]: reverse,
    },
  );

  return React.createElement('div', { className: resultClassName, ...passPropsThrough });
};

Toolbar.propTypes = {
  className: PropTypes.string,
  align: PropTypes.oneOf(['left', 'right']),
  justifyContent: PropTypes.oneOf(['end']),
  inline: PropTypes.bool,
};

Toolbar.defaultProps = {
  className: undefined,
  align: undefined,
  justifyContent: undefined,
  inline: false,
};

export default Toolbar;
