import React from 'react';
import cx from 'classnames';
import css from './Toolbar2.module.css';
import { Toolbar2Props } from './Toolbar2.types';

export const Toolbar2 = (props: Toolbar2Props) => {
  const { left = <span />, right, className, gapSize = 's', ...other } = props;

  return (
    <div className={cx(className, css.Toolbar2, css[`Toolbar2_gapSize_${gapSize}`])} {...other}>
      {left && <div className={cx(css.Toolbar2__side, css.Toolbar2__side_left)}>{left}</div>}
      {right && <div className={cx(css.Toolbar2__side, css.Toolbar2__side_right)}>{right}</div>}
    </div>
  );
};
