import React, { FC, useCallback, useMemo } from 'react';
import { Toolbar2 } from 'components/Toolbar2';
import Button from '@crm/components/dist/lego2/Button/Button';
import { Set } from 'immutable';
import css from './Buttons.module.css';
import { ButtonsProps } from '../TreeView.types';

export const ButtonsClearAll: FC<ButtonsProps> = React.memo(
  ({ savedSelected, currentSelected, onSave, onChange }) => {
    const handleClearAll = useCallback(() => {
      if (!currentSelected.isEmpty()) {
        onChange?.(Set([]));
      }
      if (!savedSelected.isEmpty()) {
        onSave?.();
      }
    }, [currentSelected, onChange, onSave, savedSelected]);

    const Buttons = useMemo(() => {
      return (
        <>
          <Button onClick={handleClearAll}>Сбросить</Button>
          <Button onClick={onSave}>Применить</Button>
        </>
      );
    }, [handleClearAll, onSave]);

    return (
      <div data-testid="tree-view-buttons">
        <Toolbar2 className={css.Buttons} right={Buttons} />
      </div>
    );
  },
);
