import React, { FC, useCallback, useMemo } from 'react';
import { Toolbar2 } from 'components/Toolbar2';
import Button from '@crm/components/dist/lego2/Button/Button';
import css from './Buttons.module.css';
import { ButtonsProps } from '../TreeView.types';

export const ButtonsReset: FC<ButtonsProps> = React.memo(
  ({ savedSelected, currentSelected, onSave, onChange }) => {
    const handleReset = useCallback(() => {
      if (savedSelected !== currentSelected) {
        onChange?.(savedSelected);
      }
    }, [onChange, savedSelected, currentSelected]);

    const Buttons = useMemo(() => {
      return (
        <>
          <Button onClick={handleReset}>Отменить</Button>
          <Button onClick={onSave}>Сохранить</Button>
        </>
      );
    }, [handleReset, onSave]);

    return (
      <div data-testid="tree-view-buttons">
        <Toolbar2 className={css.Buttons} right={Buttons} />
      </div>
    );
  },
);
